/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.Box2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearCurve2D;
import math.geom2d.circulinear.CirculinearCurve2DUtils;
import math.geom2d.circulinear.CirculinearCurveArray2D;
import math.geom2d.circulinear.CirculinearCurveSet2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.domain.PolyOrientedCurve2D;
import math.geom2d.transform.CircleInversion2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolyCirculinearCurve2D<T extends CirculinearContinuousCurve2D>
extends PolyOrientedCurve2D<T>
implements CirculinearContinuousCurve2D {
    public static <T extends CirculinearContinuousCurve2D> PolyCirculinearCurve2D<T> create(Collection<T> curves) {
        return new PolyCirculinearCurve2D<T>(curves);
    }

    public static <T extends CirculinearContinuousCurve2D> PolyCirculinearCurve2D<T> create(T ... curves) {
        return new PolyCirculinearCurve2D(curves);
    }

    public static <T extends CirculinearContinuousCurve2D> PolyCirculinearCurve2D<T> create(Collection<T> curves, boolean closed) {
        return new PolyCirculinearCurve2D<T>(curves, closed);
    }

    public static <T extends CirculinearContinuousCurve2D> PolyCirculinearCurve2D<T> create(T[] curves, boolean closed) {
        return new PolyCirculinearCurve2D(curves, closed);
    }

    public static <T extends CirculinearContinuousCurve2D> PolyCirculinearCurve2D<T> createClosed(T ... curves) {
        return new PolyCirculinearCurve2D(curves, true);
    }

    public PolyCirculinearCurve2D() {
    }

    public PolyCirculinearCurve2D(int size) {
        super(size);
    }

    public PolyCirculinearCurve2D(T[] curves) {
        super(curves);
    }

    public PolyCirculinearCurve2D(T[] curves, boolean closed) {
        super(curves, closed);
    }

    public PolyCirculinearCurve2D(Collection<? extends T> curves) {
        super(curves);
    }

    public PolyCirculinearCurve2D(Collection<? extends T> curves, boolean closed) {
        super(curves, closed);
    }

    @Override
    public double getLength() {
        double sum = 0.0;
        for (CirculinearCurve2D curve : this.getCurves()) {
            sum += curve.getLength();
        }
        return sum;
    }

    @Override
    public double getLength(double pos) {
        return CirculinearCurve2DUtils.getLength(this, pos);
    }

    @Override
    public double getPosition(double length) {
        return CirculinearCurve2DUtils.getPosition(this, length);
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(this, dist);
    }

    @Override
    public CirculinearContinuousCurve2D getParallel(double d) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.createContinuousParallel(this, d);
    }

    @Override
    public PolyCirculinearCurve2D<? extends CirculinearContinuousCurve2D> transform(CircleInversion2D inv) {
        int n = this.curves.size();
        PolyCirculinearCurve2D<CirculinearContinuousCurve2D> result = new PolyCirculinearCurve2D<CirculinearContinuousCurve2D>(n);
        for (CirculinearContinuousCurve2D curve : this.curves) {
            result.addCurve(curve.transform(inv));
        }
        return result;
    }

    @Override
    public Collection<? extends CirculinearElement2D> getSmoothPieces() {
        ArrayList<? extends CirculinearElement2D> result = new ArrayList<CirculinearElement2D>();
        for (CirculinearContinuousCurve2D curve : this.curves) {
            result.addAll(curve.getSmoothPieces());
        }
        return result;
    }

    @Override
    public Collection<? extends PolyCirculinearCurve2D<?>> getContinuousCurves() {
        return PolyCirculinearCurve2D.wrapCurve(this);
    }

    @Override
    public CirculinearCurveSet2D<? extends CirculinearContinuousCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curve2DUtils.clipCurve(this, box);
        int n = set.getCurveNumber();
        CirculinearCurveArray2D<CirculinearContinuousCurve2D> result = new CirculinearCurveArray2D<CirculinearContinuousCurve2D>(n);
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof CirculinearContinuousCurve2D)) continue;
            result.addCurve((CirculinearContinuousCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public PolyCirculinearCurve2D<? extends CirculinearContinuousCurve2D> getReverseCurve() {
        int n = this.curves.size();
        CirculinearContinuousCurve2D[] curves2 = new CirculinearContinuousCurve2D[n];
        int i = 0;
        while (i < n) {
            curves2[i] = ((CirculinearContinuousCurve2D)this.curves.get(n - 1 - i)).getReverseCurve();
            ++i;
        }
        return PolyCirculinearCurve2D.create((CirculinearContinuousCurve2D[])curves2, (boolean)this.closed);
    }

    @Override
    public PolyCirculinearCurve2D<? extends CirculinearContinuousCurve2D> getSubCurve(double t0, double t1) {
        Curve2D subcurve = super.getSubCurve(t0, t1);
        int n = ((CurveArray2D)subcurve).getCurveNumber();
        PolyCirculinearCurve2D<CirculinearContinuousCurve2D> result = new PolyCirculinearCurve2D<CirculinearContinuousCurve2D>(n);
        Iterator iterator = ((CurveArray2D)subcurve).iterator();
        while (iterator.hasNext()) {
            Curve2D curve = (Curve2D)iterator.next();
            if (!(curve instanceof CirculinearContinuousCurve2D)) continue;
            result.addCurve((CirculinearContinuousCurve2D)curve);
        }
        return result;
    }
}

